#version 330

#if _ANIM
uniform mat4 view;
uniform mat4 viewproj;
#else
uniform mat4 worldview;
uniform mat4 worldviewproj;
#endif

#if UNIFORM_COLOR_TEXIDX
uniform vec4 colour;
uniform float texIdx;
#endif
#if _ANIM
uniform vec4 worldMatrix3x4Array[144];
uniform float numBones;
#endif

in vec4 vertex;
in vec3 normal;
in vec4 uv0; //uv, z: special, w: packed texture indices
#if TANGENT
in vec4 tangent;
#endif
#if (VERTEX_COLOR && (UNIFORM_COLOR_TEXIDX == 0))
in vec4 colour;
#endif
#if _ANIM
in vec4 blendWeights;
in vec4 blendIndices;
#endif

out vec4 pos;
out vec3 norm;
out vec2 uv;
out vec3 idx; //texIdx - dif, nor, asg
#if TANGENT
out vec3 tang;
out vec3 binorm;
#endif
#if VERTEX_COLOR
out vec4 vcolor;
#endif

void main()
{
#if VERTEX_COLOR
	vcolor = colour;
#endif

#if _ANIM
	pos = vec4(0.0, 0.0, 0.0, 1.0);
	norm = vec3(0.0, 0.0, 0.0);
	#if _TANGENT
		tang = vec3(0.0, 0.0, 0.0);
	#endif //_TANGENT

    for (int i = 0; i < int(numBones); i++)
    {
		int idx = int(blendIndices[i]) * 3;
		float weight = blendWeights[i];
		
		mat4 worldMatrix;
		worldMatrix[0] = worldMatrix3x4Array[idx];
		worldMatrix[1] = worldMatrix3x4Array[idx + 1];
		worldMatrix[2] = worldMatrix3x4Array[idx + 2];
		worldMatrix[3] = vec4(0.0, 0.0, 0.0, 1.0);
		
		pos.xyz += weight * (vertex * worldMatrix).xyz;
		
		mat3 worldRotMatrix = mat3(worldMatrix[0].xyz, worldMatrix[1].xyz, worldMatrix[2].xyz);
		norm += weight * (normal * worldRotMatrix);
		tang += weight * (tangent.xyz * worldRotMatrix);
	}
	
	pos = view * pos;
	gl_Position = viewproj * vertex;
	
	norm = mat3(view) * normalize(norm);
	#if TANGENT
		tang = mat3(view) * normalize(tang);
		binorm = cross(norm, tang)*tangent.w;
	#endif
#else

	pos = worldview * vertex;
	gl_Position = worldviewproj * vertex;
	
	norm = mat3(worldview) * normal;
	#if TANGENT
		tang = mat3(worldview) * tangent.xyz;
		binorm = cross(norm, tang)*tangent.w;
	#endif
#endif

	uv = uv0.xy;
	
#if UNIFORM_COLOR_TEXIDX
	float difIdx = texIdx;
#else
	float difIdx = uv0.w;
#endif
	float asgIdx = floor(difIdx/65536 + 0.5);
	difIdx -= asgIdx*65536;
	float norIdx = floor(difIdx/256 + 0.5);
	difIdx -= norIdx*256;
	idx = vec3(difIdx, norIdx, asgIdx);
}
